USE $(DATA_BASE_NAME);
GO

DROP VIEW [dm].[vwDartParticipantLocationReport]
GO

/****** Object:  View [dm].[vwDartParticipantLocationReport]    Script Date: 2/24/2016 1:58:21 PM ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

Create view [dm].[vwDartParticipantLocationReport]
as

select req.TrackingNumber
              , p.FullName
              , p.Name as DomainName
              , loc.Name
              , case when part.principalInvestigator = 1 then 'Principal Investigator' else '' end as [PI]
              , case when part.[Notification] = 1 then 'Yes' else 'No' end as GetsNotifications
              , case when part.DataAccess = 1 then 'Yes' else 'No' end as HasDataAccess
from hib.Request req
       left join hib.participant part on req.ID = part.RequestID
       left join hib.Person p on part.PersonID = p.ID 
       left join hib.Location loc on part.LocationID = loc.ID

GO
